function send=SendOSCMessage(address,port,head,data)
% function send=SendOSCMessage(address,port,head,data)
% Encapsulate head and data in OSC protocol then send it with UPD 
% UDP function used is pnet from TCP_UDP_IP toolbox
% This toolbox should be installed first
% INPUT:
% - address: string with IP address (ex: 10.104.11.14)
% - port: int, port number to connect, default= 7770
% - head: head of the OSC protocol must start with '/'
% - data: single vector of data (single matlab type)
% OUTPUT: 
% - size: the size of the sent data
% send=SendOSCMessage('localhost',7770,'/alpha',[9  34 343 52435 6256
% 5445]);

% Author: Quentin Noirhomme

% Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
% Burak Arslan, Andrew Brouse, Julien Castet, Jean-Julien Filatriau,
% Rmy Lehembre, Quentin Noirhomme, and Cdric Simon

% Permission is hereby granted, free of charge, to any person obtaining a copy
% of this software and associated documentation files (the "Software"), to
% deal in the Software without restriction, including without limitation the
% rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
% sell copies of the Software, and to permit persons to whom the Software is
% furnished to do so, subject to the following conditions:

% The above copyright notice and this permission notice shall be included in
% all copies or substantial portions of the Software.

% Users shall give appropriate references to the eNTERFACE'05 Website
% (www.enterface.net) in scholarly literature for which this software is used
% or mentioned.

% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
% FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
% IN THE SOFTWARE.


daze=max(size(data));

udp=pnet('udpsocket',3333); %default port to send data. should be changed
pnet(udp,'write',head);
pnet(udp,'write',uint8(0)); % mandatory zero to finish the string
temp1=mod(max(size(head))+1,4); % check number of zero to add
if temp1>0
  temp2=4-temp1; % number of zero to add
  for i=1:temp2 % add zero at the end to get a multiple of 4
    pnet(udp,'write',uint8(0));
  end
end

pnet(udp,'write',','); % comma to start the type tag
for i=1:daze
    pnet(udp,'write','f'); % number of float to write
end
pnet(udp,'write',uint8(0)); % mandatory zero to finish the typetag string
temp1=mod(daze+2,4); % check number of zero to add
if temp1>0
    temp2=4-temp1; % number of zero to add
    for i=1:temp2 % add zero at the end to get a multiple of 4
        pnet(udp,'write',uint8(0));
    end 
end
for i=1:daze % write the data
   pnet(udp,'write',single(data(i)),'intel');
end
send=pnet(udp,'writepacket',address,port);
pnet(udp,'close');